${gg.setOverride(true)}
<#include "/macro.include"/>
<#assign className = table.className>
<#assign classNameLower = className?uncap_first>
package ${basepkg_dao};

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.jdbc.SQL;

import com.webapp.mybatis.helper.DaoHelper;
import com.webapp.mybatis.helper.Where;

/**
 * @description: The automatically generated ${className}Dao
 * @Package  ${basepkg_dao}
 * @Date	 ${.now?string("yyyy-MM-dd HH:mm:ss")}
 */
public interface ${className}Dao {

	<#list table.columns as column>
	<#if column.columnAlias?matches(".*\\(.+\\).*")>
	public enum ${column.columnName}{
		<#assign types = column.columnAlias?split('(')[1]?split(')')[0]>
		<@type ','/>
		<@type '，'/>
		private int index;
		private String desc;
		${column.columnName}(int index, String desc){
			this.index = index;
			this.desc = desc;
		}
		public int getIndex() {
			return index;
		}
		public String getDesc() {
			return desc;
		}
	}
	</#if>
	</#list>

	public enum Enum${className}{
		<#list table.columns as column>${column?upper_case}<#if column_has_next>,</#if></#list>
	}

	String pkey = "key";
	String pval = "val";
	String table = "${table.sqlName}";
	String selCols = "<#list table.columns as column>${column.sqlName}<#if column.columnNameLower != column.sqlName> ${column.columnNameLower}</#if><#if column_has_next>,</#if></#list>";
	String insCols = "<#list table.columns as column>${column.sqlName}<#if column_has_next>,</#if></#list>";
	String insVals = "<#list table.columns as column>${'#{'}${column.columnNameLower}${'}'}<#if column_has_next>,</#if></#list>";
	String updCols = "<#list table.notPkColumns as column>${column.sqlName}=<@mapperEl column.columnNameFirstLower/><#if column_has_next>,</#if></#list>";
	String insMulVals = "<#list table.columns as column>${'#{'}it.${column.columnNameLower}${'}'}<#if column_has_next>,</#if></#list>";

	<#list table.columns as column>
	<#if column.pk>
	/** select by pk ${column.sqlName} **/
	@SelectProvider(type=SqlProvider.class, method="getByPk")
	public ${className} getBy${column.columnName}(<@pkparam/>);

	/** delete by pk ${column.sqlName} **/
	@DeleteProvider(type=SqlProvider.class, method="delByPk")
    public boolean delBy${column.columnName}(<@pkparam/>);

    /** update by pk ${column.sqlName} **/
    @UpdateProvider(type=SqlProvider.class, method="updByPk")
	public boolean updBy${column.columnName}(${className} ${classNameLower});

	</#if>
	<#if column.unique && !column.pk>
	/** select by unique ${column.sqlName} **/
	@SelectProvider(type=SqlProvider.class, method="getBy${column.columnName}")
	public ${className} getBy${column.columnName}(${column.simpleJavaType} ${column.columnNameLower});

	/** delete by unique ${column.sqlName} **/
	@DeleteProvider(type=SqlProvider.class, method="delBy${column.columnName}")
    public boolean delBy${column.columnName}(${column.simpleJavaType} ${column.columnNameLower});

    /** update by unique ${column.sqlName} **/
    @UpdateProvider(type=SqlProvider.class, method="updBy${column.columnName}")
	public boolean updBy${column.columnName}(${className} ${classNameLower});

	</#if>
	</#list>

	/** count all record **/
	@SelectProvider(type=SqlProvider.class, method="count")
	public Integer count();

	/** count by where key=val **/
	@SelectProvider(type=SqlProvider.class, method="countByKV")
	public Integer countByKV(@Param(pkey)Enum${className} key, @Param(pval)Object val);

	/** count by where key1=val1 and key2=val2 ... **/
	@SelectProvider(type=SqlProvider.class, method="countByMap")
	public Integer countByMap(Map<String, Object> params);

	@SelectProvider(type=SqlProvider.class, method="countByModel")
	public Integer countByModel(${className} ${classNameLower});

	@SelectProvider(type=SqlProvider.class, method="countByWhere")
	public Integer countByWhere(Where where);

	@SelectProvider(type=SqlProvider.class, method="countBySql")
	public Integer countBySql(String sql);

	/** select all record **/
	@SelectProvider(type=SqlProvider.class, method="getAll")
	public List<${className}> getAll();

	/** select List<${className}> by where key=val **/
	@SelectProvider(type=SqlProvider.class, method="getByKV")
	public List<${className}> getByKV(@Param(pkey)Enum${className} key, @Param(pval)Object val);

	/** select List<${className}> by where key1=val1 and key2=val2 ... **/
	@SelectProvider(type=SqlProvider.class, method="getByMap")
	public List<${className}> getByMap(Map<String, Object> params);

	@SelectProvider(type=SqlProvider.class, method="getByModel")
	public List<${className}> getByModel(${className} ${classNameLower});

	@SelectProvider(type=SqlProvider.class, method="getByWhere")
	public List<${className}> getByWhere(Where where);

	@SelectProvider(type=SqlProvider.class, method="getBySql")
	public List<${className}> getBySql(String sql);

	@SelectProvider(type=SqlProvider.class, method="getBySql")
	public List<Map<String, Object>> getMapBySql(String sql);

	@SelectProvider(type=SqlProvider.class, method="getByWhere")
	public ${className} getOneByWhere(Where where);

	@SelectProvider(type=SqlProvider.class, method="getBySql")
	public ${className} getOneBySql(String sql);

	/** insert a ${className} **/
	@Insert("insert into " + table + "(" + insCols + ") values(" + insVals + ")")
	@SelectKey(statement="select last_insert_id()", keyProperty="id", before=false, resultType=<@pktype/>.class)
    public boolean add(${className} ${classNameLower});

	/** insert List<${className}> **/
	@Insert("<script>insert into " + table + " (" + insCols + ") values "
            + "<foreach item='it' collection='list' separator=','>(" + insMulVals + ")</foreach></script>")
	public boolean adds(@Param("list")List<${className}> list);

	/** delete by where key=val **/
	@DeleteProvider(type=SqlProvider.class, method="delAll")
    public boolean delAll();

	/** delete by where key=val **/
	@DeleteProvider(type=SqlProvider.class, method="delByKV")
    public boolean delByKV(@Param(pkey)Enum${className} key, @Param(pval)Object val);

	/** delete by where key1=val1 and key2=val2 ... **/
	@DeleteProvider(type=SqlProvider.class, method="delByMap")
    public boolean delByMap(Map<String, Object> params);

	@DeleteProvider(type=SqlProvider.class, method="delByModel")
    public boolean delByModel(${className} ${classNameLower});

	@DeleteProvider(type=SqlProvider.class, method="delByWhere")
    public boolean delByWhere(Where where);

	@DeleteProvider(type=SqlProvider.class, method="delBySql")
    public boolean delBySql(String sql);


	static class SqlProvider {
		private SQL baseDel(){
			return new SQL().DELETE_FROM(table);
		}
		public SQL baseUpd(){
			return new SQL().UPDATE(table);
		}
		private SQL baseGet(){
			return new SQL().SELECT(selCols).FROM(table);
		}
		private SQL baseCount(){
			return new SQL().SELECT("count(1)").FROM(table);
		}

		<#list table.columns as column>
		<#if column.pk>
		public String updByPk(${className} model){
			String set = DaoHelper.upd(model);
			return baseUpd().SET(set).WHERE("<@pkwhere/>").toString();
		}
		public String getByPk(<@pkparam/>){
			return baseGet().WHERE("<@pkwhere/>").toString();
		}
		public String delByPk(<@pkparam/>){
			return baseDel().WHERE("<@pkwhere/>").toString();
		}
		</#if>
		<#if column.unique && !column.pk>
		public String updBy${column.columnName}(${className} model){
			String set = DaoHelper.upd(model);
			return baseUpd().SET(set).WHERE("<@uniquewhere column/>").toString();
		}
		public String getBy${column.columnName}(${column.simpleJavaType} ${column.columnNameLower}){
			return baseGet().WHERE("<@uniquewhere column/>").toString();
		}
		public String delBy${column.columnName}(${column.simpleJavaType} ${column.columnNameLower}){
			return baseDel().WHERE("<@uniquewhere column/>").toString();
		}
		</#if>
		</#list>

		public String getAll(){
			return baseGet().toString();
		}
		public String getByKV(Map<String, Object> param){
			return baseGet().WHERE(DaoHelper.kv(param)).toString();
		}
		public String getByMap(Map<String, Object> params){
			return baseGet().WHERE(DaoHelper.exp(params)).toString();
		}
		public String getByModel(${className} model){
			return baseGet().WHERE(DaoHelper.exp(model)).toString();
		}
		public String getByWhere(Where where){
			return DaoHelper.wrap(baseGet(), where);
		}
		public String getBySql(String sql){
			return sql;
		}

		public String delAll(){
			return baseDel().toString();
		}
		public String delByKV(Map<String, Object> param){
			return baseDel().WHERE(DaoHelper.kv(param)).toString();
		}
		public String delByMap(Map<String, Object> params){
			return baseDel().WHERE(DaoHelper.exp(params)).toString();
		}
		public String delByModel(${className} model){
			return baseDel().WHERE(DaoHelper.exp(model)).toString();
		}
		public String delByWhere(Where where){
			return DaoHelper.wrap(baseDel(), where);
		}
		public String delBySql(String sql){
			return sql;
		}

		public String count(){
			return baseCount().toString();
		}
		public String countByKV(Map<String, Object> param){
			return baseCount().WHERE(DaoHelper.kv(param)).toString();
		}
		public String countByMap(Map<String, Object> params){
			return baseCount().WHERE(DaoHelper.exp(params)).toString();
		}
		public String countByModel(${className} model){
			return baseCount().WHERE(DaoHelper.exp(model)).toString();
		}
		public String countByWhere(Where where){
			return DaoHelper.wrap(baseCount(), where);
		}
		public String countBySql(String sql){
			return sql;
		}
	}
}
